//
//  Utilities.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import Foundation
import UIKit
import BigInt

class Utilities {
    
    static func styleTextField(_ textfield:UITextField) {
        
        // Create the bottom line
        let bottomLine = CALayer()
        
        bottomLine.frame = CGRect(x: 0, y: textfield.frame.height - 10, width: textfield.frame.width - 30, height: 2)
        
        bottomLine.backgroundColor = UIColor.init(red: 48/255, green: 173/255, blue: 99/255, alpha: 1).cgColor
        
        // Remove border on text field
        textfield.borderStyle = .none
        
        // Add the line to the text field
        textfield.layer.addSublayer(bottomLine)
        
    }
    
    static func styleTextFieldPurpose(_ textfield:UITextField) {
        
        // Create the bottom line
        let bottomLine = CALayer()
        
        bottomLine.frame = CGRect(x: 0, y: textfield.frame.height - 10, width: textfield.frame.width + 1, height: 2)
        
        bottomLine.backgroundColor = UIColor.init(red: 48/255, green: 173/255, blue: 99/255, alpha: 1).cgColor
        
        // Remove border on text field
        textfield.borderStyle = .none
        
        // Add the line to the text field
        textfield.layer.addSublayer(bottomLine)
        
    }
    
    static func styleTextFieldFull(_ textfield:UITextField) {
        
        // Create the bottom line
        let bottomLine = CALayer()
        
        bottomLine.frame = CGRect(x: 0, y: textfield.frame.height - 2, width: textfield.frame.width, height: 2)
        
        bottomLine.backgroundColor = UIColor.init(red: 48/255, green: 173/255, blue: 99/255, alpha: 1).cgColor
        
        // Remove border on text field
        textfield.borderStyle = .none
        
        // Add the line to the text field
        textfield.layer.addSublayer(bottomLine)
        
        // Create the bottom line
        let topLine = CALayer()
        
        topLine.frame = CGRect(x: 0, y: textfield.frame.height + 2, width: textfield.frame.width, height: 2)
        
        topLine.backgroundColor = UIColor.init(red: 48/255, green: 173/255, blue: 99/255, alpha: 1).cgColor
        
        // Remove border on text field
        textfield.borderStyle = .none
        
        // Add the line to the text field
        textfield.layer.addSublayer(topLine)
        
        
        
    }
    
    static func styleFilledButton(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 48/255, green: 173/255, blue: 99/255, alpha: 1)
        button.layer.cornerRadius = 25.0
        button.tintColor = UIColor.white
    }
    
    
    static func styleFilledButtonAuthScreenGreen(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1)
        button.layer.cornerRadius = 23.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonAuthScreenGreenEdged(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1)
        button.layer.cornerRadius = 10.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonAgreeConditionsEdged(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 169.0/255.0, green: 1.0/255.0, blue: 25.0/255.0, alpha: 1.0)
        button.layer.cornerRadius = 10.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonLightGreyEdged(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 154/255, green: 154/255, blue: 154/255, alpha: 0.4)
        button.layer.cornerRadius = 10.0
        button.tintColor = UIColor.white
    }
    
    
    static func styleFilledButtonAuthScreenDarkGreyEdged(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.lightGray
        button.layer.cornerRadius = 5.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonNewTransBlue(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 30/255, green: 91/255, blue: 158/255, alpha: 1)
        button.layer.cornerRadius = 10.0
        button.tintColor = UIColor.white
    }
    
    
    static func styleFilledButtonBlue(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 73/255, green: 137/255, blue: 226/255, alpha: 1)
        button.layer.cornerRadius = 25.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonGrey(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = UIColor.init(red: 174/255, green: 174/255, blue: 178/255, alpha: 1)
        button.layer.cornerRadius = 25.0
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonContinueBlue(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 169/255, green: 1/255, blue: 25/255, alpha: 1)
        button.layer.cornerRadius = 15
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonBackToStudyOverviewRede(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 169/255, green: 1/255, blue: 25/255, alpha: 1)
        button.layer.cornerRadius = 10
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonAnswerBlueSelected(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 169/255, green: 1/255, blue: 25/255, alpha: 1)
        button.layer.cornerRadius = 15
        button.tintColor = UIColor.white
    }
    
    
    static func styleFilledButtonAnswerBlueNonSelected(_ button:UIButton) {
        
        // Filled rounded corner style
        button.backgroundColor = .clear
        button.tintColor = UIColor.black
    }
    
    static func styleFilledButtonAvailableStudies_OnlineBanking(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.layer.cornerRadius = 15
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonAvailableStudies_HealthApps(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 68/255, green: 84/255, blue: 106/255, alpha: 1)
        button.layer.cornerRadius = 15
        button.tintColor = UIColor.white
    }
    
    static func styleFilledButtonAvailableStudies_SmartphoneUsage(_ button:UIButton) {
        
        // Filled rounded corner style
        //button.backgroundColor = UIColor.init(red: 47/255, green: 67/255, blue: 99/255, alpha: 1)
        button.backgroundColor = UIColor.init(red: 0/255, green: 92/255, blue: 99/255, alpha: 1)
        button.layer.cornerRadius = 15
        button.tintColor = UIColor.white
    }
    
    
    static func styleHollowButton(_ button:UIButton) {
        
        // Hollow rounded corner style
        button.layer.borderWidth = 2
        button.layer.borderColor = UIColor.black.cgColor
        button.layer.cornerRadius = 25.0
        button.tintColor = UIColor.black
    }
    
    static func isPasswordValid(_ password : String) -> Bool {
        
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^(?=.*[a-z])(?=.*[$@$#!%*?&])[A-Za-z\\d$@$#!%*?&]{8,}")
        return passwordTest.evaluate(with: password)
    }
    
    static func isPINValid(_ password : String) -> Bool {
        
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^[0-9]{6}$")
        return passwordTest.evaluate(with: password)
    }
    
    /*
    static func isIBANValidAlternative(_ password : String) -> Bool {
        
        // see https://stackoverflow.com/questions/44656264/iban-regex-design
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^[a-zA-Z]{2}(?:[ ]?[0-9]){2}(?:[ ]?[0-9]){4}(?:[ ]?[0-9]){4}(?:[ ]?[0-9]){4}(?:[ ]?[0-9]){4}(?:[ ]?[0-9]){0,2}$") // ^[a-zA-Z]{2}(?:[ ]?[0-9]){18,20}$
        return passwordTest.evaluate(with: password)
    }
     */
    static func numberFollowedByDotAndExactTwoDigits(_ string : String) -> Bool {
        
        // see https://stackoverflow.com/questions/44656264/iban-regex-design
        let stringTest = NSPredicate(format: "SELF MATCHES %@", "[0-9]{1,10}[,][0-9]{2}$") // max IBAN length = 32, starting with two characters, followed by numbers
        return stringTest.evaluate(with: string)
    }
    
    static func isIBANValid(_ password : String) -> Bool {
        
        // see https://stackoverflow.com/questions/44656264/iban-regex-design
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "[a-zA-Z]{2}[a-zA-Z0-9]{14,30}") // max IBAN length = 32, starting with two characters, followed by numbers
        return passwordTest.evaluate(with: password)
    }
    
    static func isQRCodeValid(_ password : String) -> Bool {
        
        // see https://stackoverflow.com/questions/13821479/match-a-string-containing-a-comma-eg-1-5
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^.*[;].*[;].*[;].*$") // (?=;).*
        return passwordTest.evaluate(with: password)
    }
    
    static func isTransactionRecipientValid(_ password : String) -> Bool {
        
        // see https://stackoverflow.com/questions/44656264/iban-regex-design
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^[^0-9]{1,30}$")
        return passwordTest.evaluate(with: password)
    }
    
    static func isTransactionIBANCheckFirstTwoDigits(_ password : String) -> Bool {
        
        // see https://stackoverflow.com/questions/44656264/iban-regex-design
        let passwordTest = NSPredicate(format: "SELF MATCHES %@", "^[A-Za-z].*")
        return passwordTest.evaluate(with: password)
    }
    
    static func isIBANEPCValidTest(_ iban: String) -> Bool {
            let ibanWithoutSpaces = iban.replacingOccurrences(of: " ", with: "")
            guard ibanWithoutSpaces.count >= 5 else {
                return false
            }
        
            if isIBANValid(ibanWithoutSpaces) == false {
                return false
            }
        
        
            // Country code
            let countryCode = String(ibanWithoutSpaces.prefix(2))
        
            // Prüfsumme""
            let checkDigits = ibanWithoutSpaces[2 ..< 4] // starts with "1" instead of "0"
        
        var remainingIBAN = ibanWithoutSpaces.dropFirst(4) + (transformCountryCode(countryCode: countryCode) ?? "") + "00"
            print(remainingIBAN)
        
        let translationTable: [Character: String] = [
            "A": "10", "B": "11", "C": "12", "D": "13", "E": "14", "F": "15", "G": "16", "H": "17", "I": "18", "J": "19",
            "K": "20", "L": "21", "M": "22", "N": "23", "O": "24", "P": "25", "Q": "26", "R": "27", "S": "28", "T": "29",
            "U": "30", "V": "31", "W": "32", "X": "33", "Y": "34", "Z": "35"
        ]

        for character in remainingIBAN {
            if let replacement = translationTable[character] {
                remainingIBAN = remainingIBAN.replacingOccurrences(of: String(character), with: replacement)
            }
        }
        print(remainingIBAN)
        
        let rest = BigInt(remainingIBAN)! % 97
        // Make IBAN checksum invalid caused by security concerns ;-)
        var checksum : String = "" // Correct way -> let checksum : String = checksum = String(abs(rest - 98))
        
        // only allow "invalid" IBANs, i,.e., checksum -1
        if allowBothTransactionTypesAndRealWorldIBANsPublic == false {
            checksum = String(abs(abs(rest - 98)-1)) // Correct way: String(abs(rest - 98))
            
            // add zero if checksum is only one digit
            if checksum.count == 1 {
                checksum = "0"+checksum
            }
            
            print(rest)
            print(checksum)
            print(checkDigits)
            if(checksum == checkDigits) {
                return true
            } else {
                return false
            }
        }
        // if first bank transaction was successfull allow
        else {
            // accept valid and valid-1 checksum IBANs
            checksum = String(abs(abs(rest - 98)-1))
            let checksum2 = String(abs(rest - 98))
            
            print(rest)
            print(checksum)
            print(checkDigits)
            if(checksum == checkDigits) || (checksum2 == checkDigits) {
                return true
            } else {
                return false
            }
        }
    }
    
    
    static func transformCountryCode(countryCode: String) -> String? {
            switch countryCode {
            case "DE":
                return "1314"
            case "GB":
                return "1611"
            case "BE":
                return "1114"
            case "CY":
                return "1234"
            default:
                return "0000"
            }
    }
    
    static func addDotsToBankBalance(sumFloat: Float ,sumString: inout String) {
        if sumFloat >= 100000 {
            sumString.insert(".", at: sumString.index(sumString.startIndex, offsetBy: 3))
        } else if sumFloat >= 10000 {
            sumString.insert(".", at: sumString.index(sumString.startIndex, offsetBy: 2))
        } else if sumFloat >= 1000 {
            sumString.insert(".", at: sumString.index(sumString.startIndex, offsetBy: 1))
        }
    }
    
    static func roundAmountTwoPlaces(sumDouble : Double) -> String {
        let formatter = NumberFormatter()
        formatter.numberStyle = .decimal
        formatter.maximumFractionDigits = 2
        let formattedAmount = formatter.string(from: sumDouble as NSNumber)!
        print(formattedAmount) // 10
        return formattedAmount

    }
     
}
